//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Stage 1.0
import wesual.Ui     1.0

ContainerOption {

    defaultValue : 0

    property string label
    property var    options
    property int    minimumValue : 20
    property int    maximumValue : 1000

    Column {
        property ContainerOption containerOption

        spacing : 9

        UiLabel { text : containerOption.label }

        UiSpinBox {

            step : 1
            decimals : 0
            bindable : true
            value : containerOption.value

            minimumValue : containerOption.minimumValue
            maximumValue : containerOption.maximumValue

            onUpdateRequested : containerOption.updateValue(newValue)
        }
    }
}

